* Section 5.3: Compare actual net benefit to potential net benefit with optimal card
* Date last edited: 02 October 2018
* File author: Mary-Alice Doyle

* (in excel) I have identified 18 out of our list of 250 cards that are not stritly domianted by another -
// based on interest rate, annual fee, interest-free period and the $ equivalent rewards rebate per cent per dollar spent. 
// and based on advertised card characteristics at the end of 2016.
* I calculate the net benefit for each respondent for each of those 18 cards, 
//and select the one that gives the maximum net benefit for each respondent.
* I then compare that 'optimal' net benefit with their actual net benefit,  
//to estimate the difference between actual and optimal card choice.
* Note: this is just an approximation, and doesn't account for respondents' eligibility for cards, or for lower acceptance of AmEx and Diners

*cd [specify filepath for working directory]
use ".\Data\CCholdingdata.dta", clear
set more off
drop if ccown==0
drop if ccmainfee>=1000

* Own main card 
gen fee0 = ccmainfee if ccmainfee!=-5
gen rate0 = ccmainrate if ccmainrate!=-5
gen days0 = ccmainday if ccmainday!=-5
gen rewards0 = ccmainrebate if !inlist(ccmainrebate,-5,-1)
replace rewards0 = 0 if ccmainrebate==-1
* ^ For this exercise I need to make simplifying assumptions, which is why the
// benefit from the respondent's actual card here will be slightly different from my preferred measure

* Card 218 - 
gen fee1 = 0
gen rate1=11.5
gen days1 = 55
gen rewards1 = 0

* Card 2 - 
gen fee2=0
gen rate2=14.99
gen days2=55
gen rewards2=0.740740741

* Card 91 -
gen fee3=0
gen rate3=19.99
gen days3=62
gen rewards3=0.25

* Card 143 - 
gen fee4=0
gen rate4=22.74
gen days4=62
gen rewards4=0.761614623

* Card 107 - 
gen fee5=30
gen rate5=10.49
gen days5=55
gen rewards5=0

* Card 188 - 
gen fee6=36
gen rate6=7.99
gen days6=55
gen rewards6=0

* Card 192 - 
gen fee7=39
gen rate7=13.2
gen days7=55
gen rewards7=0.666666667

* Card 89 - 
gen fee8=49
gen rate8=12.99
gen days8=62
gen rewards8=0

* Card 40 - 
gen fee9=49
gen rate9=11.99
gen days9=55
gen rewards9=0.4

* Card 90 - 
gen fee10=49
gen rate10=19.99
gen days10=62
gen rewards10=1

* Card 94 - 
gen fee11=59
gen rate11=20.24
gen days11=55
gen rewards11=0.75

* Card 24 - 
gen fee12=95
gen rate12=18.79
gen days12=55
gen rewards12=0.899887514

* Card 41 - 
gen fee13=129
gen rate13=18.49
gen days13=55
gen rewards13=0.8

* Card 104 - 
gen fee14=249
gen rate14=20.24
gen days14=55
gen rewards14=1.25

* Card 248 - 
gen fee15=250
gen rate15=19.99
gen days15=45
gen rewards15=0.903614458

* Card 15 - 
gen fee16=295
gen rate16=19.99
gen days16=55
gen rewards16=0.903614458

* Card 96 - 
gen fee17=349
gen rate17=20.24
gen days17=55
gen rewards17=1.5

* Card 112 - 
gen fee18=389
gen rate18=42.57608868
gen days18=44
gen rewards18=1.675977654



*******
* Define variables
*******


* Step 1: Rewards
***************
* Annual spend based on monthly total
gen annualspend = (q7e / 0.99) * 12 if q7e>=0


* Step 2: Annual fee
***************
*Indicator for whether discounted/waived
gen annualfee_d = .
replace annualfee_d = 1 if ccown == 1
replace annualfee_d = 0 if q7d == 3 | q7d == 4
replace annualfee_d = .5 if q7d == 2
label define annualfee_d 0 "waived (0)" 1 "everyone else - incl zero annual fee (1)"
replace fee0 = annualfee_d*fee0 if fee0>=0
* ^ for main cc, we incorporate information in discounted fees, but for alternatives, we assume no discount.
label val annualfee_d annualfee_d


* Step 3: Value of interest-free period
***************
gen ifp_used = .
replace ifp_used = 1 if ccrepay == 2
replace ifp_used = 0 if ccrepay == 4
replace ifp_used = 0 if ccrepay == 5
replace ifp_used = 30/ccmainday if ccrepay == 1 & ccmainday >=0
replace ifp_used = 0.6 if ccmainday==-5 & ccrepay==1
replace ifp_used = 15/ccmainday if ccrepay == 3 & ccmainday>=0
replace ifp_used = 0.25 if ccrepay == 3 & ccmainday==-5
replace ifp_used = 0.75 if ccrepay == 6

* Alternative interest rates
gen alt_ir=.
replace alt_ir = 0.0525 if q8f == 3
replace alt_ir = 0.1390 if q8f == 4
replace alt_ir = 0.0205 if inlist(q8f,1,2,5)



* Step 4: Interest paid
******************
gen interest_freq = 0 if ccrepay>0
replace interest_freq = 1 if !inlist(ccrepay,5,6) & q7f>0
replace interest_freq = 3 if ccrepay==6
replace interest_freq = 12 if ccrepay==5



* Loop through all 18 cards to find optimal for each cardholder in the sample
forvalues i = 0/18 {

		* Step 1
		******************
		gen rewards_annualval = 0
		replace rewards_annualval = rewards`i'/100* annualspend  if annualspend!=. 
		replace rewards_annualval = . if annualspend==.
				
		* $ value of annual fee

		* Step 2.5: Net value of payment function
		******************
		gen netpmtfunction = rewards_annualval - fee`i'

		* Step 3: Interest-free period
		*******************
		* Value of interest free period - assuming balance is accrued in the middle of the month (day 15)
		gen ifp_potential = annualspend * alt_ir *(days`i'-15)/365 
		label var ifp_potential "Value of IFP if respondent pays off on the due date"
		
		gen ifp_value = ifp_potential * ifp_used
		label var ifp_value "Actual value of IFP based on reported fequency of cc repayments (from ccrepay)"
		
		* Step 4: Interest paid
		*********************
		gen r`i'= rate`i'/ccmainrate if ccmainrate!=.
		* Ratio of alternative card interest rate to actual card's rate. 
		//We can use this to get an estimate of the value of interest the 
		//respondent would pay if they had a different interest rate. 
		gen interest_paid =0 if q7b!=-2 & q7f!=-2
		replace interest_paid = q7f * interest_freq * r`i' if q7f>=0

		
		* Step 4.5: Net value of borrowing function
		********************
		gen netborrowingvalue = ifp_value - interest_paid

		* STEP 5: put everything together
		********
		gen netbenefit`i'= netpmtfunction + netborrowingvalue
		drop rewards_annualval netpmtfunction ifp_potential ifp_value netborrowingvalue interest_paid
	
	}

egen nboptimal = rowmax(netbenefit0 netbenefit1 netbenefit2 netbenefit3 netbenefit4 netbenefit5 netbenefit6 netbenefit7 netbenefit8 netbenefit9 netbenefit10 netbenefit11 netbenefit12 netbenefit13 netbenefit14 netbenefit15 netbenefit16 netbenefit17 netbenefit18)
replace nboptimal = . if netbenefit0==.

* Potential gain from switching to optimal card
gen optimalactual = netbenefit0-nboptimal

********
* Figure 7
********
** Generate data for cumulative distribution graphs
* Optimal card
egen netbenefitbinsoptimal = cut(nboptimal), at(-14000(20)24000)
quietly: tabout netbenefitbinsoptimal if idtag==1 [aw=w1] using ".\Excel output\5.3 optimal distribution.xls", f(4) c(col) replace

* Actual card
egen netbenefitbinsactual = cut(netbenefit0), at(-22000(20)10000)
quietly: tabout netbenefitbinsactual if idtag==1 [aw=w1] using ".\Excel output\5.3 optimal distribution.xls", f(4) c(col) append

* Difference (not used in graph)
egen netbenefitbinsoptimalactual = cut(optimalactual), at(-10000(20)1)
quietly: tabout netbenefitbinsoptimalactual if idtag==1 [aw=w1] using ".\Excel output\5.3 optimal distribution.xls", f(4) c(col) append


*********
* Statements in text
*********
* bins of <-50, -50 to 50, and 50+
egen netactual50 = cut(netbenefit0), at(-22000,-50,50,24000)
egen netoptimal50 = cut(nboptimal), at(-22000,-50,50,24000)

* the median cardholder's actual net monetary benefit was around $120 lower than it would be if they held an optimal card
table idtag if idtag==1 [pw=w1], c(mean optimalactual median optimalactual)

* of those who made an actual loss, 65 per cent could have avoided that loss altogether
tablecol  netoptimal50 idtag if idtag==1 & netactual50==-22000 [pw=w1], colpct
* for these respondents, the median difference in net benefit between optimal and actual card was $150
table idtag if inlist(netoptimal50,-50,50) & netactual50==-22000 & idtag==1 [pw=w1], c(mean optimalactual median optimalactual)

* most (65%) respondents who usually or often pay interest would continue to make a net loss
tablecol  netoptimal50 idtag if idtag==1 & netactual50==-22000 & revolver==1 [pw=w1], colpct
* but this loss would be substantially smaller
table idtag if inlist(netoptimal50,-50,50) & netactual50==-22000 & revolver==1 & idtag==1 [pw=w1], c(mean optimalactual median optimalactual)

* of the 10% of respondents who would continue to make a loss if they held an optimal card
tablecol netoptimal50 idtag if idtag==1 [pw=w1], colpct
* the median value of this loss would fall from $530 to $280
table netoptimal50 idtag if idtag==1 [pw=w1], c(median netbenefit0 median nboptimal median optimalactual)
